// Solution to problem `Risk'
// Order: N^2 * D^2
//
// Rudy van Vliet, 14 September, 2015

#include<iostream>
#include<cstring>
#include<iomanip>

using namespace std;

const int MaxDiceNr = 20;
const int MaxN = 100;

double probability[MaxN+1][MaxN+1];
        // [i][j]: probability that attacker with i armies beats
        //         defender with j armies
double probScore2[MaxDiceNr+1][MaxDiceNr+1];
        // [die1][die2]: probability that attacker with 2 dice has scores
        //    die1 >= die2
double probScore3[MaxDiceNr+1][MaxDiceNr+1];
        // [die1][die2]: probability that attacker with 3 dice has maximum
        //    scores die1 >= die2
double probScoreLoss[MaxDiceNr+1][3][2];
        // [die1][l][m]: probability that attacker with 1 die,
        //    with score die1, versus defender with l dice
        //    looses m armies
double probScore2Loss[MaxDiceNr+1][MaxDiceNr+1][3][3];
        // [die1][die2][l][m]: probability that attacker with >= 2 dice,
        //    with maximum scores die1 >= die2, versus defender with l dice
        //    looses m armies

  // for purely scientific purposes
int diceChosen[MaxDiceNr+1][MaxDiceNr+1],
      // [die1][die2]: how many dice has defender chosen to use,
      //   when attacker had scores die1 >= die2
    ijWhenChose1[MaxDiceNr+1][MaxDiceNr+1][2],
      // [die1][die2]: what are the smallest values of (i,j) for which
      //   the defender chose to use one die, when attacker had scores
      //   die1 >= die2
    ijWhenChose2[MaxDiceNr+1][MaxDiceNr+1][2];
      // [die1][die2]: what are the smallest values of (i,j) for which
      //   the defender chose to use two dice, when attacker had scores
      //   die1 >= die2

//*************************************************************************

bool IntegerInRange (const char *variable, int val, int minVal, int maxVal)
{
  if (val>=minVal && val<=maxVal)
    return true;
  else
  { cout << variable << "=" << val << ", but should be in [" << minVal
         << "," << maxVal << "]" << endl;
    return false;
  }

}  // IntegerInRange

//*************************************************************************

// Initlalize arrays about chosen number of dice.
void InitChosen (int diceNr)
{ int die1, die2;

  for (die1=1;die1<=diceNr;die1++)
    for (die2=1;die2<=die1;die2++)
    { diceChosen[die1][die2] = 0;
      ijWhenChose1[die1][die2][0] = MaxN+1;
      ijWhenChose1[die1][die2][1] = MaxN+1;
      ijWhenChose2[die1][die2][0] = MaxN+1;
      ijWhenChose2[die1][die2][1] = MaxN+1;
    }

}  // InitChosen

//*************************************************************************

// Update arrays about chosen number of dice, when
// - attacker has i>=3 armies
// - attacker has thrown two or three dice with highest values first
//   and second, respectively
// - defender has j>=2 armies
// - defender chose to use `choice' dice
void UpdateChosen (int i, int j, int first, int second, int choice)
{
  if (choice==1)
  { if (diceChosen[first][second]%2==0)  // first time we chose one die
      diceChosen[first][second]+=1;      // for this pair (first,second)

    if (i+j < ijWhenChose1[first][second][0]+ijWhenChose1[first][second][1])
    { ijWhenChose1[first][second][0] = i;
      ijWhenChose1[first][second][1] = j;
    }
  }
  else  // choice==2
  { if (diceChosen[first][second]<=1)  // first time we chose two dice
      diceChosen[first][second]+=2;    // for this pair (first,second)

    if (i+j < ijWhenChose2[first][second][0]+ijWhenChose2[first][second][1])
    { ijWhenChose2[first][second][0] = i;
      ijWhenChose2[first][second][1] = j;
    }
  }
  
}  // UpdateChosen

//*************************************************************************

// Print contents of arrays about chosen number of dice onto the screen.
void PrintChosen (int diceNr)
{ int die1, die2;

  for (die1=1;die1<=diceNr;die1++)
  { for (die2=1;die2<=die1;die2++)
      cout << diceChosen[die1][die2];
    cout << endl;
  }
  cout << endl;

  cout << "Chose1\n";
  for (die1=1;die1<=diceNr;die1++)
  { for (die2=1;die2<=die1;die2++)
    { if (ijWhenChose1[die1][die2][0]<=MaxN)  // a real value
        cout << '(' << setw(2) << ijWhenChose1[die1][die2][0]
             << ',' << setw(2) << ijWhenChose1[die1][die2][1]
             << ") ";
      else
        cout << "(--,--) ";
    }
    cout << endl;
  }
  cout << endl;

  cout << "Chose2\n";
  for (die1=1;die1<=diceNr;die1++)
  { for (die2=1;die2<=die1;die2++)
    { if (ijWhenChose2[die1][die2][0]<=MaxN)  // a real value
        cout << '(' << setw(2) << ijWhenChose2[die1][die2][0]
             << ',' << setw(2) << ijWhenChose2[die1][die2][1]
             << ") ";
      else
        cout << "(--,--) ";
    }
    cout << endl;
  }
  cout << endl;

}  // PrintChosen

//*************************************************************************

// Print contents of array probabilities onto the screen.
void PrintProbabilities ()
{ int i, j;

  cout << "   ";
  for (j=0;j<=MaxN;j++)
    cout << setw(7) << j;
  cout << endl;

  for (i=1;i<=MaxN;i++)
  { cout << setw(3) << i;
    for (j=0;j<=MaxN;j++)
      cout << ' ' << setiosflags(ios::fixed) << setprecision(4)
           << probability[i][j];
    cout << endl;
  }
  cout << endl;

}  // PrintProbabilities

//*************************************************************************

// Print values on diagonal of array probabilities.
void PrintDiagonalProbabilities ()
{ int i;

  for (i=1;i<=MaxN;i++)
  { cout << '(' << setw(2) << i << ',' << setw(2) << i << ')';
    cout << ' ' << setiosflags(ios::fixed) << setprecision(4)
           << probability[i][i] << endl;
  }
  cout << endl;

}  // PrintDiagonalProbabilities

//*************************************************************************

void ComputeProbScore23 (int diceNr)
{ int die1, die2, die3,
      first, second,
      allfirst, allsecond;
  double prob1, prob2, prob3,
         prob;

  for (die1=1;die1<=diceNr;die1++)
    for (die2=1;die2<=die1;die2++)  // we only compute case die1 >= die2
    { probScore2[die1][die2] = 0.0;
      probScore3[die1][die2] = 0.0;
    }

  for (die1=1;die1<=diceNr;die1++)
  { prob1 = 1.0/diceNr;

    for (die2=1;die2<=diceNr;die2++)
    { prob2 = 1.0/diceNr;
      prob = prob1*prob2;

      if (die1>=die2)
      { first = die1;
        second = die2;
      }
      else
      { first = die2;
        second = die1;
      }
      probScore2[first][second] += prob;

      for (die3=1;die3<=diceNr;die3++)
      { prob3 = 1.0/diceNr;
        prob = prob1*prob2*prob3;

        allfirst = first;
        allsecond = second;

        if (die3>allsecond)  // pair (allfirst,allsecond) changes
        { if (die3>allfirst)  // new maximum
          { allsecond = allfirst;
            allfirst = die3;
          }
          else
            allsecond = die3;
        }
        probScore3[allfirst][allsecond] += prob;

      }  // for die3

    }  // for die2

  }  // for die1

}  // ComputeProbScore23

//*************************************************************************

void ComputeProbScoreLoss (int diceNr)
{ int die1,
      die3, die4,
      l, m;
  double prob;

  for (die1=1;die1<=diceNr;die1++)
  {     // initialize probScoreLoss
      for (l=1;l<=2;l++)
        for (m=0;m<=1;m++)
          probScoreLoss[die1][l][m] = 0.0;

      for (die3=1;die3<=diceNr;die3++)
      {   // first consider case that defender uses only one die (l=1)
        prob = 1.0/diceNr;
        if (die3>=die1)  // attacker looses one army
          probScoreLoss[die1][1][1] += prob;
        else
          probScoreLoss[die1][1][0] += prob;

          // now consider case that defender uses two dice (l=2) 
        for (die4=1;die4<=die3;die4++)
        {
          prob = probScore2[die3][die4];

          if (die3>=die1)  // attacker looses one army
            probScoreLoss[die1][2][1] += prob;
          else  // attacker looses zero armies
            probScoreLoss[die1][2][0] += prob;

        }  // for die4

      }  // for die3

  }  // for die1

}  // ComputeProbScoreLoss

//*************************************************************************

void ComputeProbScore2Loss (int diceNr)
{ int die1, die2,
      die3, die4,
      l, m;
  double prob;

  for (die1=1;die1<=diceNr;die1++)
  { for (die2=1;die2<=die1;die2++)  // we only compute case die1 >= die2
    {   // initialize probScore2Loss
      for (l=1;l<=2;l++)
        for (m=0;m<=2;m++)
          probScore2Loss[die1][die2][l][m] = 0.0;

      for (die3=1;die3<=diceNr;die3++)
      {   // first consider case that defender uses only one die (l=1)
        prob = 1.0/diceNr;
        if (die3>=die1)  // attacker looses one army
          probScore2Loss[die1][die2][1][1] += prob;
        else
          probScore2Loss[die1][die2][1][0] += prob;

          // now consider case that defender uses two dice (l=2) 
        for (die4=1;die4<=die3;die4++)
        {
          prob = probScore2[die3][die4];

          if (die3>=die1)
          { if (die4>=die2)  // attacker looses two armies
              probScore2Loss[die1][die2][2][2] += prob;
            else  // attacker looses one army
              probScore2Loss[die1][die2][2][1] += prob;
          }
          else  // die3<die1
          { if (die4>=die2)  // attacker looses one army
              probScore2Loss[die1][die2][2][1] += prob;
            else  // attacker looses zero armies
              probScore2Loss[die1][die2][2][0] += prob;
          }

        }  // for die4

      }  // for die3

    }  // for die2

  }  // for die1

}  // ComputeProbScore2Loss

//*************************************************************************

// Determine probability that attacker wins, when
// - attacker has i>=3 armies
// - attacker has thrown two or three dice with highest values first
//   and second, respectively
// - defender has j>=1 armies
double DetermineProbability (int i, int j, int first, int second)
{ double probability1, probability2,
         result;

    // probability in case defender uses one die
  probability1 = probScoreLoss[first][1][0]*probability[i][j-1] +
                 probScoreLoss[first][1][1]*probability[i-1][j];

  if (j==1)  // if defender has only one army, he has only one die
    result = probability1;

  else  // if defender has two or more armies, he can choose
        // whether to use one or two dice
  {   // probability in case defender uses two dice
    probability2 = probScore2Loss[first][second][2][0]*probability[i][j-2] +
                   probScore2Loss[first][second][2][1]*probability[i-1][j-1] +
                   probScore2Loss[first][second][2][2]*probability[i-2][j];

    if (probability1<=probability2)  // defender chooses to use one die
    { result = probability1;
      UpdateChosen (i, j, first, second, 1);
    }
    else  // defender chooses to use two dice
    { result = probability2;
      UpdateChosen (i, j, first, second, 2);
    }
  }

  return result;

}  // DetermineProbability

//*************************************************************************

void ComputeProbability (int diceNr)
{ int i, j,
      die1, die2;
  double prob;

    // fill in probability [i][0]
  for (i=1;i<=MaxN;i++)  // if defender has no armies, attacker has won
    probability[i][0] = 1.0;

    // fill in probability [1][j]
  for (j=1;j<=MaxN;j++)  // if attacker has only one army, he has lost
    probability[1][j] = 0.0;

    // fill in probability [2][j]
  i = 2;
  for (j=1;j<=MaxN;j++)  // if attacker has two armies, he has one die
  { probability[i][j] = 0.0;  // initialize probability

    for (die1=1;die1<=diceNr;die1++)
    { prob = 1.0/diceNr;

      if (j==1)  // if defender has only one army, he has one die
      { probability[i][j] += prob * 
          (probScoreLoss[die1][1][0]*probability[i][j-1] +
           probScoreLoss[die1][1][1]*probability[i-1][j]
            // this second term always equals 0.0
          );
      }
      else  // if defender has two or more armies, he always uses two dice
            // in this case
      { probability[i][j] += prob * 
          (probScoreLoss[die1][2][0]*probability[i][j-1] +
           probScoreLoss[die1][2][1]*probability[i-1][j]
            // this second term always equals 0.0
          );
      }

    }  // for die1

  }  // for j

    // fill in probability [i][j] for i>=3
  for (i=3;i<=MaxN;i++)  // if attacker has three armies, he has two dice
                // if attacker has four or more armies, he has three dice
  { for (j=1;j<=MaxN;j++)
    { probability[i][j] = 0.0;  // initialize probability

      for (die1=1;die1<=diceNr;die1++)
      { for (die2=1;die2<=die1;die2++)
        {
          if (i==3)  // attacker has two dice
          { prob = probScore2[die1][die2];

            probability[i][j] += prob * 
                DetermineProbability (i, j, die1, die2);
          }  // i=3

          else  // i>=4, so attacker has three dice
          { prob = probScore3[die1][die2];

            probability[i][j] += prob * 
                DetermineProbability (i, j, die1, die2);
          }  // else: i>=4

        }  // for die2

      }  // for die1

    }  // for j

  }  // for i

}  // ComputeProbability

//*************************************************************************

int main()
{ int nInst, inst,
      d,  // = diceNr
      n, m;

  cin >> nInst;
  for (inst=1;inst<=nInst;inst++)
  {
    cin >> d;
    if (IntegerInRange ("number of dice", d, 1, MaxDiceNr))
    {
      InitChosen (d);
      ComputeProbScore23 (d);
      ComputeProbScoreLoss (d);
      ComputeProbScore2Loss (d);
      ComputeProbability (d);
//      PrintChosen (d);
//      PrintProbabilities ();
//      PrintDiagonalProbabilities ();

      cin >> m >> n;
      if (IntegerInRange("m",m,2,MaxN) && IntegerInRange ("n",n,1,MaxN))
        cout << probability[m][n] << endl;
    }
  }

  return 0;
}
