/*
Solution by Jan Elffers.

// @EXPECTED_RESULTS@: CORRECT

Running time: O(n*m*log(n*m))
Memory usage: O(n*m)
*/

#include<bits/stdc++.h>
using namespace std;

// using union-find with path compression to compute the connected components incrementally.

int par[105*105];
int find(int x){
	int root=x;
	while(par[root]!=root)root=par[root];
	while(x!=root){
		int y=par[x];
		par[x]=root;
		x=y;
	}
	return root;
}

int main(){
	int T;
	scanf("%d",&T);
	for(int tc=1;tc<=T;tc++){
		int w,h;
		scanf("%d%d",&w,&h);
		int p,c;
		scanf("%d%d",&p,&c);
		for(int i=0;i<h*w;i++)par[i]=i;
		par[h*w]=h*w;
		for(int it=0;it<p;it++){
			int x,y;
			scanf("%d%d",&x,&y);
			par[y*w+x]=h*w;
		}
		// read the edges and use union-find to maintain the connected components
		for(int it=0;it<c;it++){
			int x,y;
			scanf("%d%d",&x,&y);
			static char dir[5];
			scanf("%s",dir);
			int x2,y2;
			if(dir[0]=='U')x2=x,y2=y+1;else x2=x+1,y2=y;
			// unite (y,x) and (y2,x2)
			par[find(y2*w+x2)]=find(y*w+x);
		}
		// count the number of connected components without power supply
		int answer=0;
		for(int i=0;i<h*w;i++)if(find(i)!=find(h*w) && find(i)==i)answer++;
		printf("%d\n",answer);
	}
}
