// Solution to problem `Icelandic Motor Clubs'
// Order: N
// Rudy van Vliet, 4 September, 2015

#include<iostream>
#include<cstring>

using namespace std;
const int MaxN = 5000000;
int gas[MaxN+1], dist[MaxN+1]; // declared globally to avoid segmentation fault

int main()
{ int nInst, inst;
  int N, i,
      start, gasleft;
  bool found, stop;
  

  cin >> nInst;
  for (inst=1;inst<=nInst;inst++)
  {
    cin >> N;
    for (i=1;i<=N;i++)
      cin >> gas[i] >> dist[i];

    start = 1;
    found = false;
    stop = false;
    do  // see if we can make a roundtrip starting at gas station `start'
    { i = start;
      gasleft = 0;

      do
      { gasleft += (gas[i]-dist[i]);
        if (gasleft>=0)
          i = (i%N)+1;
      } while (i!=start && gasleft>=0);

      if (gasleft<0)
        // Gas station i caused the biker to run out of gas.
        // Hence, it does not make sense to start anywhere between
        // the old value of `start' and i.
      { if (i<start)
            // In this iteration of the outer do-loop, i has iterated
            // from start, to N, to 1, and then to its current value
            // which is less than start.
          stop = true;
        else
          if (i==N)  // next value for start would be 1, which we tried already
            stop = true;
          else
            start = i+1;
      }
      else
        found = true;
      
    } while (!found && !stop);

    if (found)
      cout << start << endl;
    else
      cout << "IMPOSSIBLE" << endl;

  }

  return 0;
}
